#version 330
#extension GL_EXT_gpu_shader4 : enable
// Underwater metalMod01.fsh  by  ClySuva

//https://www.shadertoy.com/view/4dBcDw
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float random(vec3 scale,float seed){return fract(sin(dot(gl_FragCoord.xyz+seed,scale))*43758.5453+seed);}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    
    uv.y += sin(iTime + uv.x * 4.0)* 0.1;
    uv.y += sin(iTime + uv.y * 2.0)* 0.1;
    uv.x += iTime * 0.1;
    
    vec2 uv2 = uv;
    uv2.x += iTime * 0.05;
    uv2.y += sin(iTime * 0.1);
        
    vec4 color=vec4(0.0);
	float total=0.0;
    vec2 delta = vec2(uv.y * 0.01, uv.y * 0.01);
	float offset=random(vec3(12.9898,78.233,151.7182),0.0);
	for(float t=-30.0;t<=30.0;t++){
		float percent=(t+offset-0.5)/30.0;
		float weight=1.0-abs(percent);
		vec4 smp = (texture2D(iChannel0, uv + delta * percent) * 2.0 - .5) +
        ((1.0 - texture2D(iChannel1, uv2 + delta * percent).r) * 0.4);
		smp.rgb*=smp.a;
		color+=smp*weight;
		total+=weight;
	}
	
	gl_FragColor=color/total;
    gl_FragColor.rgb/=gl_FragColor.a+0.00001;
    gl_FragColor.r -= 0.3;
    gl_FragColor.g -= 0.15;      
}
